/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PicketsBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)2.0);
    public static final VoxelShape WEST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_COLL = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape EAST_COLL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0);
    public static final VoxelShape SOUTH_COLL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0);
    public static final VoxelShape WEST_COLL = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public PicketsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        ArrayList<VoxelShape> SHAPES = new ArrayList<VoxelShape>();
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            SHAPES.add(NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            SHAPES.add(EAST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            SHAPES.add(SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            SHAPES.add(WEST_SHAPE);
        }
        if (!SHAPES.isEmpty()) {
            VoxelShape result = (VoxelShape)SHAPES.get(0);
            for (int i = 1; i < SHAPES.size(); ++i) {
                result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)((VoxelShape)SHAPES.get(i)));
            }
            return result;
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        ArrayList<VoxelShape> COLLISION = new ArrayList<VoxelShape>();
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            COLLISION.add(NORTH_COLL);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            COLLISION.add(EAST_COLL);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            COLLISION.add(SOUTH_COLL);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            COLLISION.add(WEST_COLL);
        }
        if (!COLLISION.isEmpty()) {
            VoxelShape result = (VoxelShape)COLLISION.get(0);
            for (int i = 1; i < COLLISION.size(); ++i) {
                result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)((VoxelShape)COLLISION.get(i)));
            }
            return result;
        }
        return super.m_5939_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction playerDir = ctx.m_8125_().m_122424_();
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            Direction facingDirection = this.getFacingDirection(blockState);
            if (facingDirection != playerDir) {
                return (BlockState)super.m_152465_(blockState).m_61124_(this.getFacingProperty(playerDir), (Comparable)Boolean.valueOf(true));
            }
        } else {
            return (BlockState)((BlockState)super.m_49966_().m_61124_(this.getFacingProperty(playerDir), (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (context.m_43723_() != null) {
            Direction playerDir = context.m_8125_().m_122424_();
            Direction facingDirection = this.getFacingDirection(state);
            return !context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && facingDirection != playerDir || super.m_6864_(state, context);
        }
        return true;
    }

    private Direction getFacingDirection(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)NORTH)).booleanValue()) {
            return Direction.NORTH;
        }
        if (((Boolean)blockState.m_61143_((Property)EAST)).booleanValue()) {
            return Direction.EAST;
        }
        if (((Boolean)blockState.m_61143_((Property)SOUTH)).booleanValue()) {
            return Direction.SOUTH;
        }
        if (((Boolean)blockState.m_61143_((Property)WEST)).booleanValue()) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    private Property<Boolean> getFacingProperty(Direction direction) {
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

